<?php

namespace Opencart\Admin\Controller\Extension\EveryPay\Payment;

use Opencart\System\Engine\Config;
use Opencart\System\Engine\Controller;

class EveryPay extends Controller {
	private $error = array();
	private $version = 'v1.0.0';
	private $separator = '';

	public function __construct($registry) {
		parent::__construct($registry);

		if (VERSION >= '4.0.2.0') {
			$this->separator = '.';
		} else {
			$this->separator = '|';
		}
	}

	public function index() {
		$this->language->load('extension/everypay/payment/everypay');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');
		$this->load->model('localisation/order_status');

		$this->load->model('localisation/language');

		$this->install();

		// Setting Form entities
		$data['heading_title'] = $this->language->get('heading_title');
		$data['version'] = $this->version;
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_test'] = $this->language->get('text_test');
		$data['text_live'] = $this->language->get('text_live');
		$data['text_authorization'] = $this->language->get('text_authorization');
		$data['text_capture'] = $this->language->get('text_capture');

		$data['entry_api_username'] = $this->language->get('entry_api_username');
		$data['entry_api_secret'] = $this->language->get('entry_api_secret');
		$data['entry_test_api_username'] = $this->language->get('entry_test_api_username');
		$data['entry_test_api_secret'] = $this->language->get('entry_test_api_secret');
		$data['entry_account_name'] = $this->language->get('entry_account_name');
		$data['entry_mode'] = $this->language->get('entry_mode');
		$data['entry_transaction_type'] = $this->language->get('entry_transaction_type');
		$data['entry_total'] = $this->language->get('entry_total');
		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['help_total'] = $this->language->get('help_total');
		$data['help_processing_account'] = $this->language->get('help_processing_account');
		$data['help_mode'] = $this->language->get('help_mode');
		$data['help_order_status'] = $this->language->get('help_order_status');
		$data['help_sort_order'] = $this->language->get('help_sort_order');
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['action'] = $this->url->link('extension/everypay/payment/everypay' . $this->separator . 'save', 'user_token=' . $this->session->data['user_token']);
		$data['cancel'] = $this->url->link('extension/everypay/payment', 'user_token=' . $this->session->data['user_token']);

		// breadcrumbs
		$data['breadcrumbs'] = [];
		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'])
		];
		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'])
		];
		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/everypay/payment/everypay', 'user_token=' . $this->session->data['user_token'])
		];

		// Setting
		$_config = new Config();
		$_config->addPath(DIR_EXTENSION . 'everypay/system/config/');
		$_config->load('everypay');

		$data['setting'] = $_config->get('everypay_setting');
		$data['setting'] = array_replace_recursive((array)$data['setting'], (array)$this->config->get('payment_everypay_setting'));
		$data['callback_url'] = HTTP_CATALOG . 'index.php?route=extension/everypay/payment/everypay' . $this->separator . 'process';

		// Account setting
		$configValues = [
			'payment_everypay_account_name',
			'payment_everypay_api_username',
			'payment_everypay_api_secret',
			'payment_everypay_test_api_username',
			'payment_everypay_test_api_secret',
			'payment_everypay_geo_zone_id',
			'payment_everypay_total',
			'payment_everypay_sort_order',
			'payment_everypay_status',
		];
		foreach ($configValues as $config) {
			$data[$config] = $this->config->get($config);
		}

		//pull in all geo zones the store has
		$this->load->model('localisation/geo_zone');
		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		//allow setting different checking heading titles per language
		$languages = $this->model_localisation_language->getLanguages();

		$data['payment_everypay_title'] = array(
			'type' => 'langtext',
			'name' => 'payment_everypay_title',
			'label' => $this->language->get('entry_title'),
			'value' => $this->_getLangValue('payment_everypay_title', $this->config, $this->request->post, $languages),
			'languages' => $languages,
		);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		$this->response->setOutput($this->load->view('extension/everypay/payment/everypay', $data));
	}

	public function install() {
		if ($this->user->hasPermission('modify', 'marketplace/extension')) {
			$this->load->model('extension/everypay/payment/everypay');

			$this->model_extension_everypay_payment_everypay->install();
		}
	}

	public function save(): void {
		$this->load->language('extension/everypay/payment/everypay');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->load->model('setting/setting');

			$this->model_setting_setting->editSetting('payment_everypay', $this->request->post);

			$data['success'] = $this->language->get('text_success');
		}

		$data['error'] = $this->error;

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($data));
	}

	private function _getLangValue($field, $config, $request, $languages, $default = '') {
		$values = array();
		foreach ($languages as $language) {
			$values[$field . '_' . $language['language_id']] = $this->_getValue($field . '_' . $language['language_id'], $config, $request, $default);
		}
		return $values;
	}

	private function _getValue($field, $config, $request, $default = '') {
		$value = '';
		if (isset($request[$field])) {
			$value = $request[$field];
		} else {
			$value = $config->get($field);
		}
		if ($value === false || $value === null) {
			$value = $default;
		}
		return $value;
	}

	/**
	 * Validates inputs
	*
	* @return bool
	*/
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/everypay/payment/everypay')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['payment_everypay_account_name']) {
			$this->error['account-name'] = $this->language->get('error_account_name');
		}

		return !$this->error;
	}
}
