<?php

$GLOBALS['everypay'] = array(
	'urlLive' => 'https://pay.every-pay.eu/api/v3/payments/oneoff',
	'urlTest' => 'https://igw-demo.every-pay.com/api/v3/payments/oneoff',
	'urlLiveStatus' => 'https://pay.every-pay.eu/api/v3/payments/',
	'urlTestStatus' => 'https://igw-demo.every-pay.com/api/v3/payments/',
);

class ControllerExtensionPaymentEveryPay extends Controller {
	protected $globalURLs;

	public function index() {
		$this->load->language('extension/payment/everypay');

		$data['button_payment_confirmation'] = ($this->language->get('button_payment_confirmation')
			&& (mb_strlen($this->language->get('button_payment_confirmation')) > 0))
			? $this->language->get('button_payment_confirmation')
			: 'Proceed to Payment';
		$data['payment_url'] = $this->url->link('extension/payment/everypay/redirect', '', true);

		return $this->load->view('extension/payment/everypay', $data);
	}

	public function redirect()
	{
		include_once DIR_APPLICATION . '../system/library/Everypay.php';
		$this->load->language('extension/payment/everypay');
		$this->load->model('checkout/order');
		$this->load->model('extension/payment/everypay');

		$this->model_extension_payment_everypay->updatePaymentTitle($this->session->data['order_id']);
		$order = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		$countryCode = $order['payment_iso_code_2'];

		$fields = array(
			'account_name' => $this->config->get('payment_everypay_account_name'),
			'amount' => $order['total'],
			'billing_city' => $order['payment_city'],
			'billing_country' => $countryCode,
			'billing_line1' => $order['payment_address_1'],
			'billing_line2' => $order['payment_address_2'] ? $order['payment_address_2'] : '-',
			'billing_postcode' => $order['payment_postcode'],
			'customer_url' => $this->url->link('extension/payment/everypay/customerReturn', '', true),
			'shipping_city' => $order['shipping_city'],
			'shipping_country' => $order['shipping_iso_code_2'],
			'shipping_line1' => $order['shipping_address_1'],
			'shipping_line2' => $order['shipping_address_2'] ? $order['shipping_address_2'] : '-',
			'shipping_code' => $order['shipping_postcode'],
			'shipping_state' => $order['shipping_zone'],
			'email' => $order['email'],
			'order_reference' => $order['order_id'],
			'customer_ip' => $order['ip'],
			'integration_details' => [
				'integration' => 'EveryPay Plugin',
				'version' => '1.9.9',
				'software' => 'OpenCart ' . VERSION,
			],
		);

		if (!empty($this->getPreferredCountry($countryCode))) {
			$fields['preferred_country'] = $countryCode;
		}

		$everyPay = new Everypay();

		if ($this->config->get('payment_everypay_mode') === 'live') {
			$fields['api_username'] = $this->config->get('payment_everypay_api_username');
			$everyPay->init($this->config->get('payment_everypay_api_username'), $this->config->get('payment_everypay_api_secret'));
		} else {
			$fields['api_username'] = $this->config->get('payment_everypay_test_api_username');
			$everyPay->init($this->config->get('payment_everypay_test_api_username'), $this->config->get('payment_everypay_test_api_secret'));
		}

		$data['checkout_title'] = 'EveryPay';
		$data['form_data'] = $everyPay->getFields($fields, $order['language_code']);

		$this->globalURLs =& $GLOBALS['everypay'];

		if ($this->config->get('payment_everypay_mode') === 'live') {
			$username = $this->config->get('payment_everypay_api_username');
			$password = $this->config->get('payment_everypay_api_secret');
			$url = $this->globalURLs['urlLive'];
		} else {
			$username = $this->config->get('payment_everypay_test_api_username');
			$password = $this->config->get('payment_everypay_test_api_secret');
			$url = $this->globalURLs['urlTest'];
		}

		$request = $this->sendPostRequestWithBasicAuth($url, $data['form_data'], $username, $password);
		$result = json_decode($request, true);

		return $this->response->redirect(isset($result['payment_link']) ? $result['payment_link']: '/');
	}

    private function getPreferredCountry($countryCode) {
		$allowedCountryCodes = ['EE', 'LV', 'LT'];

		if (in_array($countryCode, $allowedCountryCodes)) {
			return $countryCode;
		} else {
			return '';
		}
	}

	private function sendPostRequestWithBasicAuth($url, $data, $username, $password) {
		$request_body = json_encode($data);
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLINFO_HEADER_OUT, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $request_body);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
				'Content-Type: application/json',
				'Accept: application/json',
				'Content-Length: ' . strlen($request_body))
		);
		curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password);
		$response = curl_exec($ch);
		curl_close($ch);
		return $response;
	}

	private function sendGetRequestWithAuth($url, $username, $password){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
				'Content-Type: application/json'
			)
		);
		curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password);
		$response = curl_exec($ch);
		curl_close($ch);
		return json_decode($response, true);
	}

	private function getPaymentResultUrl($payment_reference, $api_username) {
		$globalURLs = $this->globalURLs =& $GLOBALS['everypay'];
		$everyPay = new Everypay();

		if($this->config->get('payment_everypay_mode')=== 'live') {
			$everyPay->init($this->config->get('payment_everypay_api_username'), $this->config->get('payment_everypay_api_secret'));
			$url = $globalURLs['urlLiveStatus'];
		} else {
			$everyPay->init($this->config->get('payment_everypay_test_api_username'), $this->config->get('payment_everypay_test_api_secret'));
			$url = $globalURLs['urlTestStatus'];
		}

		return $url . $payment_reference . "?api_username=" . $api_username;
	}

	public function process() {
		$this->load->model('checkout/order');
		include_once DIR_APPLICATION . '../system/library/Everypay.php';
		$everyPay = new Everypay();

		if ($this->config->get('payment_everypay_mode') === 'live') {
			$everyPay->init($this->config->get('payment_everypay_api_username'), $this->config->get('payment_everypay_api_secret'));
		} else {
			$everyPay->init($this->config->get('payment_everypay_test_api_username'), $this->config->get('payment_everypay_test_api_secret'));
		}

		$response = $_REQUEST;
		$payment_reference = $_REQUEST['payment_reference'];
		$order_reference = $_REQUEST['order_reference'];
		$response['api_username'] = $everyPay->getApiUsername();
		$response['api_secret'] = $everyPay->getApiSecret();

		$stateRequest = $this->sendGetRequestWithAuth($this->getPaymentResultUrl($payment_reference, $response['api_username']), $response['api_username'], $response['api_secret'])["payment_state"];
		$response['payment_state'] = $stateRequest;

		try {
			$this->load->model('extension/payment/everypay');
			$this->model_extension_payment_everypay->addOrderPaymentStatus($order_reference, $stateRequest);
		} catch (Exception $e) {}

		$status = $everyPay->verify($response);

		switch($status) {
			case 1 : $this->model_checkout_order->addOrderHistory($order_reference, $this->config->get('payment_everypay_order_status_id'), '', true);
				$this->response->redirect($this->url->link('checkout/success'));
				break;
			case 2 : $this->model_checkout_order->addOrderHistory($order_reference, 7, '', true);
				$this->response->redirect($this->url->link('checkout/checkout'));
				break;
			case 3 : $this->model_checkout_order->addOrderHistory($order_reference, 10, '', true);
				$this->response->redirect($this->url->link('checkout/failure'));
				break;
			// #19031 here we set order status as 'pending' and show redirect user to 'success' order placement page
			case 4 : $this->model_checkout_order->addOrderHistory($order_reference, 1, '', true);
				$this->response->redirect($this->url->link('checkout/success'));
				break;
			default : $this->response->redirect($this->url->link('checkout/checkout'));
		}
	}

	public function customerReturn() {
		sleep(2);
		$this->load->model('checkout/order');
		$this->load->model('extension/payment/everypay');

		$order_reference = htmlentities($_REQUEST['order_reference']);
		if (empty($order_reference)) {
			$this->response->redirect($this->url->link('checkout/checkout'));
		}

		$paymentStatus = $this->model_extension_payment_everypay->getPaymentStatusByReference($order_reference);
		if (empty($paymentStatus)) {
			$this->displayNoStatusMessage();
			return;
		}

		$order = $this->model_checkout_order->getOrder($order_reference);
		if (empty($order)) {
			$this->response->redirect($this->url->link('checkout/checkout'));
		}

		switch($order['order_status_id']) {
			case $this->config->get('payment_everypay_order_status_id'):
			case 1:
			case 7:
				$this->response->redirect($this->url->link('checkout/success'));
				break;
			case 10:
				$this->response->redirect($this->url->link('checkout/failure'));
				break;
			default:
				$this->response->redirect($this->url->link('checkout/checkout'));
		}
	}

	private function displayNoStatusMessage() {
		$this->load->language('checkout/checkout');
		$this->load->language('extension/payment/everypay');

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_cart'),
			'href' => $this->url->link('checkout/cart')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('checkout/checkout', '', true)
		);

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');
		$data['message'] = $this->language->get('no_status_message');

		$this->response->setOutput($this->load->view('extension/payment/everypay_no_status', $data));
	}
}
